VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} FeatureStepper 
   Caption         =   "Feature Stepper"
   ClientHeight    =   465
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   2745
   OleObjectBlob   =   "FeatureStepper.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "FeatureStepper"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False



'    This is a part of the source code for Pro/DESKTOP.
'    Copyright (C) 1999-2002 Parametric Technology Corporation.
'    All rights reserved.
'
'    Step singly through a design's feature list; a shortcut to
'    dragging the finish flag and updating.
'

Dim app As ProDESKTOP

Dim doc As GraphicDocument
Dim design As aDesign

Private Sub Rewind_Click()
    Set doc = app.GetActiveDoc
   If TypeOf doc Is PartDocument Then
        Dim helm As helm
        Set helm = app.TakeHelm
        Set design = doc.GetDesign
        If design.GetOperationCount > 0 Then
            design.SetFinishPoint design.GetOperation(0)
            doc.UpdateDesign
        End If
        helm.CommitCalls "Rewind", False
    End If
End Sub

Private Sub FF_Click()
    Set doc = app.GetActiveDoc
    If TypeOf doc Is PartDocument Then
        Dim helm As helm
        Set helm = app.TakeHelm
        Set design = doc.GetDesign
        design.SetFinishPoint Nothing
        doc.UpdateDesign
        helm.CommitCalls "FF", False
    End If
End Sub

Function GetOperationPosition(op As aOperation) As Integer
   Dim iop As Integer
   
   For iop = 0 To design.GetOperationCount - 1
      If design.GetOperation(iop) Is op Then
        GetOperationPosition = iop
        Exit Function
      End If
   Next iop
   
   GetOperationPosition = design.GetOperationCount
End Function

Private Sub Step_Click()
    Set doc = app.GetActiveDoc
    If TypeOf doc Is PartDocument Then
        Dim helm As helm
        Set helm = app.TakeHelm
        Set design = doc.GetDesign
        Dim nop As Integer
        Dim iop As Integer
        Dim op As aOperation
        nop = design.GetOperationCount
        Set op = design.GetFinishPoint
        If op Is Nothing Then
            ' do nothing
        Else
            iop = GetOperationPosition(op)
            If iop < nop - 1 Then
                If design.GetOperationCount > iop + 1 Then
                    design.SetFinishPoint design.GetOperation(iop + 1)
                End If
            Else
                design.SetFinishPoint Nothing
            End If
        End If

        doc.UpdateDesign
        helm.CommitCalls "Step", False
    End If
End Sub

Private Sub Back_Click()
    Set doc = app.GetActiveDoc
    If TypeOf doc Is PartDocument Then
        Dim helm As helm
        Set helm = app.TakeHelm
        Set design = doc.GetDesign
    
        Dim nop As Integer
        Dim iop As Integer
        Dim op As aOperation
        nop = design.GetOperationCount
        Set op = design.GetFinishPoint
        If op Is Nothing Then
            iop = nop
        Else
            iop = GetOperationPosition(op)
        End If
    
        If iop > 0 Then
             If design.GetOperationCount > iop - 1 Then
                design.SetFinishPoint design.GetOperation(iop - 1)
            End If
        End If
        
        doc.UpdateDesign
        helm.CommitCalls "Back", False
    End If
End Sub

Private Sub Play_Click()
    Set doc = app.GetActiveDoc
    If TypeOf doc Is PartDocument Then
        Dim helm As helm
        Set helm = app.TakeHelm
        Set design = doc.GetDesign
    
        Dim nop As Integer
        Dim iop As Integer
        Dim op As aOperation
        nop = design.GetOperationCount
        Set op = design.GetFinishPoint
        
        If op Is Nothing Then
            ' do nothing
        Else
            For iop = GetOperationPosition(op) To nop - 1
                If iop < nop - 1 Then
                   design.SetFinishPoint design.GetOperation(iop + 1)
                Else
                   design.SetFinishPoint Nothing
                End If
            
                doc.UpdateDesign
                helm.CommitCalls "Step", False
            Next iop
        End If

        helm.CommitCalls "Play", False
    End If
End Sub

Private Sub UserForm_Activate()
    Set app = CreateObject("ProDESKTOP.Application")
    Dim helm As helm
    Set helm = app.TakeHelm
    helm.CommitCalls "Activate", False
End Sub

Private Sub UserForm_Initialize()
    Me.Caption = GetResourceString(551)
    Me.Rewind.ControlTipText = GetResourceString(560)
    Me.Back.ControlTipText = GetResourceString(561)
    Me.Play.ControlTipText = GetResourceString(562)
    Me.Step.ControlTipText = GetResourceString(563)
    Me.FF.ControlTipText = GetResourceString(564)
End Sub
